
// // // // // // // // // // // // // // // //
//
//	ServerApplication.cc
//
//	erstellt 4.12.97 von Andreas Warnke
//	geändert 3.5.98 von Andreas Warnke
//



// // // // // // // // // // // // // // // //
//
//	include
//

#include "ServerApplication.h"
#include "GameStatus.h"



// // // // // // // // // // // // // // // //
//
//	Konstruktor:
//

ServerApplication::ServerApplication() :
	BApplication( ServerApplication_MIME_ )
{
	//	Bildschirmkoordinaten:
	BRect Pos = GetScreenRect ();
	
	//	Distanz zum Rand:
	enum { eRand = 6 };
	
	//	Position berechnen:
	Pos.left = eRand;
	Pos.bottom = Pos.bottom - eRand;
	Pos.top = Pos.bottom - 199;
	Pos.right = Pos.left + 399;
	
	//	Set urgent priority:
	set_thread_priority ( Thread (), B_URGENT_PRIORITY / 2 );
	//	Set normal priority: error, because scrolling in the
	//	clients window disables message handling.
	/*set_thread_priority ( Thread (), B_NORMAL_PRIORITY );*/
	
	//	new GameStatus
	DerStatus = new GameStatus( Pos );
};



// // // // // // // // // // // // // // // //
//
//	Destruktor:
//

ServerApplication::~ServerApplication() 
{
};



// // // // // // // // // // // // // // // //
//
//	GetScreenRect:
//

BRect ServerApplication :: GetScreenRect ()
{
	return BScreen ( B_MAIN_SCREEN_ID ) . Frame ();
};



// // // // // // // // // // // // // // // //
//
//	GetStatus:
//

GameStatus * ServerApplication :: GetStatus() 
{
	return DerStatus;
};



// // // // // // // // // // // // // // // //
//
//	DispatchMessage:
//



void ServerApplication :: DispatchMessage ( BMessage * inMessage, BHandler * inHandler )
{
	if ( ( inMessage -> what == B_ABOUT_REQUESTED )
		&&	( DerStatus != NULL ) )
		DerStatus -> MessageReceived ( inMessage );
	else
		BApplication :: DispatchMessage ( inMessage, inHandler );
};



//
//	Ende.
//
// // // // // // // // // // // // // // // //	
